/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.google.common.collect.ImmutableMap;
import com.lilypuree.decorative_blocks.blocks.BarPanelBlock;
import com.lilypuree.decorative_blocks.blocks.BeamBlock;
import com.lilypuree.decorative_blocks.blocks.BonfireBlock;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.blocks.ChainBlock;
import com.lilypuree.decorative_blocks.blocks.ChandelierBlock;
import com.lilypuree.decorative_blocks.blocks.LatticeBlock;
import com.lilypuree.decorative_blocks.blocks.PalisadeBlock;
import com.lilypuree.decorative_blocks.blocks.PillarBlock;
import com.lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import com.lilypuree.decorative_blocks.blocks.SeatBlock;
import com.lilypuree.decorative_blocks.blocks.SupportBlock;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import com.lilypuree.decorative_blocks.fluid.ThatchFluid;
import com.lilypuree.decorative_blocks.fluid.ThatchFluidBlock;
import com.lilypuree.decorative_blocks.items.BurnableBlockItem;
import com.lilypuree.decorative_blocks.setup.ModSetup;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Registration {
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<Fluid> FLUIDS;
    public static final RegistryObject<BarPanelBlock> BAR_PANEL;
    public static final RegistryObject<LatticeBlock> LATTICE;
    public static final AbstractBlock.Properties chainProperties;
    public static final RegistryObject<ChainBlock> CHAIN;
    public static final RegistryObject<ChandelierBlock> CHANDELIER;
    public static final RegistryObject<ChandelierBlock> SOUL_CHANDELIER;
    public static final RegistryObject<BrazierBlock> BRAZIER;
    public static final RegistryObject<BrazierBlock> SOUL_BRAZIER;
    public static final RegistryObject<PillarBlock> STONE_PILLAR;
    public static final RegistryObject<Block> ROCKY_DIRT;
    public static final RegistryObject<BonfireBlock> BONFIRE;
    public static final RegistryObject<BonfireBlock> SOUL_BONFIRE;
    public static final Item.Properties modItemProperties;
    public static final Item.Properties dummyProperty;
    public static final RegistryObject<Item> BAR_PANEL_ITEM;
    public static final RegistryObject<Item> LATTICE_ITEM;
    public static final RegistryObject<Item> CHAIN_ITEM;
    public static final RegistryObject<Item> CHANDELIER_ITEM;
    public static final RegistryObject<Item> SOUL_CHANDELIER_ITEM;
    public static final RegistryObject<Item> BRAZIER_ITEM;
    public static final RegistryObject<Item> SOUL_BRAZIER_ITEM;
    public static final RegistryObject<Item> STONE_PILLAR_ITEM;
    public static final RegistryObject<Item> ROCKY_DIRT_ITEM;
    public static final Material THATCH_MATERIAL;
    private static final ResourceLocation thatchStillTexture;
    private static final ResourceLocation thatchFlowingTexture;
    public static final ThatchFluid.FluidReferenceHolder referenceHolder;
    public static final RegistryObject<FlowingFluid> FLOWING_THATCH;
    public static final RegistryObject<FlowingFluid> STILL_THATCH;
    public static final RegistryObject<Block> THATCH;
    public static final RegistryObject<EntityType<DummyEntityForSitting>> DUMMY_ENTITY_TYPE;
    public static final ImmutableMap<String, RegistryObject<Block>> DECORATIVE_BLOCKS;
    public static final ImmutableMap<String, RegistryObject<Item>> DECORATIVE_ITEMBLOCKS;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITIES.register(modEventBus);
        FLUIDS.register(modEventBus);
    }

    public static Block getWoodDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes decorativeBlockType) {
        String name = wood + "_" + (Object)((Object)decorativeBlockType);
        return (Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get();
    }

    public static RotatedPillarBlock getBeamBlock(IWoodType wood) {
        return (RotatedPillarBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.BEAM);
    }

    public static PalisadeBlock getPalisadeBlock(IWoodType wood) {
        return (PalisadeBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.PALISADE);
    }

    public static SeatBlock getSeatBlock(IWoodType wood) {
        return (SeatBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SEAT);
    }

    public static SupportBlock getSupportBlock(IWoodType wood) {
        return (SupportBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SUPPORT);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        AbstractBlock.Properties woodProperty = AbstractBlock.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).func_200943_b(1.2f).func_200947_a(wood.getSoundType());
        AbstractBlock.Properties palisadeProperty = AbstractBlock.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).func_200948_a(2.0f, 4.0f).func_200947_a(wood.getSoundType());
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty, wood);
            }
            case SEAT: {
                return new SeatBlock(woodProperty, wood);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty, wood);
            }
            case PALISADE: 
        }
        return new PalisadeBlock(palisadeProperty, wood);
    }

    static {
        String name;
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"decorative_blocks");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"decorative_blocks");
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"decorative_blocks");
        FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"decorative_blocks");
        BAR_PANEL = BLOCKS.register("bar_panel", () -> new BarPanelBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_()));
        LATTICE = BLOCKS.register("lattice", () -> new LatticeBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a).func_226896_b_()));
        chainProperties = AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(4.3f).func_200947_a(SoundType.field_185852_e).func_226896_b_();
        CHAIN = BLOCKS.register("chain", () -> new ChainBlock(chainProperties));
        CHANDELIER = BLOCKS.register("chandelier", () -> new ChandelierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 15), false));
        SOUL_CHANDELIER = BLOCKS.register("soul_chandelier", () -> new ChandelierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 11), true));
        BRAZIER = BLOCKS.register("brazier", () -> new BrazierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 15 : 0).func_226896_b_(), false));
        SOUL_BRAZIER = BLOCKS.register("soul_brazier", () -> new BrazierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 10 : 0).func_226896_b_(), true));
        STONE_PILLAR = BLOCKS.register("stone_pillar", () -> new PillarBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.5f)));
        ROCKY_DIRT = BLOCKS.register("rocky_dirt", () -> new RockyDirtBlock());
        BONFIRE = BLOCKS.register("bonfire", () -> new BonfireBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151581_o, (MaterialColor)MaterialColor.field_151656_f).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185854_g).func_235838_a_(state -> 15).func_222380_e()));
        SOUL_BONFIRE = BLOCKS.register("soul_bonfire", () -> new BonfireBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151581_o, (MaterialColor)MaterialColor.field_151679_y).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185854_g).func_235838_a_(state -> 14).func_222380_e()));
        modItemProperties = new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP);
        dummyProperty = new Item.Properties();
        BAR_PANEL_ITEM = ITEMS.register("bar_panel", () -> new BlockItem((Block)BAR_PANEL.get(), modItemProperties));
        LATTICE_ITEM = ITEMS.register("lattice", () -> new BlockItem((Block)LATTICE.get(), modItemProperties));
        CHAIN_ITEM = ITEMS.register("chain", () -> new BlockItem((Block)CHAIN.get(), modItemProperties));
        CHANDELIER_ITEM = ITEMS.register("chandelier", () -> new BurnableBlockItem((Block)CHANDELIER.get(), modItemProperties, 1600));
        SOUL_CHANDELIER_ITEM = ITEMS.register("soul_chandelier", () -> new BurnableBlockItem((Block)SOUL_CHANDELIER.get(), modItemProperties, 1600));
        BRAZIER_ITEM = ITEMS.register("brazier", () -> new BlockItem((Block)BRAZIER.get(), modItemProperties));
        SOUL_BRAZIER_ITEM = ITEMS.register("soul_brazier", () -> new BlockItem((Block)SOUL_BRAZIER.get(), modItemProperties));
        STONE_PILLAR_ITEM = ITEMS.register("stone_pillar", () -> new BlockItem((Block)STONE_PILLAR.get(), modItemProperties));
        ROCKY_DIRT_ITEM = ITEMS.register("rocky_dirt", () -> new BlockItem((Block)ROCKY_DIRT.get(), modItemProperties));
        THATCH_MATERIAL = new Material.Builder(MaterialColor.field_151673_t).func_200508_c().func_200502_b().func_200509_f().func_200507_a().func_200506_i();
        thatchStillTexture = new ResourceLocation("decorative_blocks", "block/thatch_still");
        thatchFlowingTexture = new ResourceLocation("decorative_blocks", "block/thatch_flowing");
        referenceHolder = new ThatchFluid.FluidReferenceHolder(() -> Blocks.field_150407_cf, thatchStillTexture, thatchFlowingTexture, 11308296);
        FLOWING_THATCH = FLUIDS.register("flowing_thatch", () -> new ThatchFluid.Flowing(referenceHolder));
        STILL_THATCH = FLUIDS.register("thatch", () -> new ThatchFluid.Source(referenceHolder));
        THATCH = BLOCKS.register("thatch", () -> new ThatchFluidBlock((Supplier<? extends FlowingFluid>)STILL_THATCH, AbstractBlock.Properties.func_200945_a((Material)THATCH_MATERIAL).func_200942_a().func_200944_c().func_200943_b(100.0f).func_222380_e()));
        DUMMY_ENTITY_TYPE = ENTITIES.register("dummy", () -> EntityType.Builder.func_220322_a(DummyEntityForSitting::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(20).func_220321_a(1.0E-4f, 1.0E-4f).func_206830_a("decorative_blocks:dummy"));
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
                name = wood + "_" + (Object)((Object)type);
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> Registration.createDecorativeBlock(wood, type)));
            }
        }
        DECORATIVE_BLOCKS = decorativeBlockBuilder.build();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
                name = wood + "_" + (Object)((Object)type);
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> {
                    if (wood.isFlammable()) {
                        return new BurnableBlockItem((Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty, 300);
                    }
                    return new BlockItem((Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty);
                }));
            }
        }
        DECORATIVE_ITEMBLOCKS = itemBuilder.build();
        referenceHolder.setFlowingFluid(() -> FLOWING_THATCH.get());
        referenceHolder.setStillFluid(() -> STILL_THATCH.get());
        referenceHolder.setFluidBlock(() -> THATCH.get());
    }
}

